<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model 
{

    protected $table = 'profiles';
    public $timestamps = true;
    protected $fillable = array('website_id', 'photo', 'first_name', 'last_name', 'uuid', 'about_me', 'company', 'gender', 'phone', 'mobile', 'work', 'other', 'dob', 'skypeid', 'githubid', 'twitter_username', 'instagram_username', 'facebook_username', 'facebook_url', 'linked_in_url', 'google_plus_url', 'slug', 'display_name');
    protected $visible = array('website_id', 'photo', 'first_name', 'last_name', 'uuid', 'about_me', 'company', 'gender', 'phone', 'mobile', 'work', 'other', 'dob', 'skypeid', 'githubid', 'twitter_username', 'instagram_username', 'facebook_username', 'facebook_url', 'linked_in_url', 'google_plus_url', 'slug', 'display_name');

    public function profile()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function location()
    {
        return $this->hasMany('Location');
    }

    public function website()
    {
        return $this->hasOne('Website');
    }

}